unit CommonDEF03;

interface

// ==========================================================================
// -------------------------------------------------------------------------
// 02.01.2020
type TAppConst = record
      // ------------------------------
      //   
      AppType  : string;
      AppName  : string;
      AppVers  : string;
      AppAutor : string;
      AppCopyR : string;
      // ------------------------------
      //     ()
      ImgFileName : string;
      ImgWidth    : integer;  //   
      ImgHeight   : integer;  //   
      // ------------------------------
      //    
      Osc01Width  : integer;  //   
      Osc01Heigth : integer;  //   
      // ------------------------------
      //   ALARM - 
      AlarmWidth  : integer;  //   
      AlarmHeight : integer;  //   
      // ------------------------------
      //      
      MaxGrmNum   : integer;
      // ------------------------------
      //       MaxGrmNum
      //  
      MaxSampNum  : integer;
end;
// -------------------------------------------------------------------------
//       
type TWallStyle  = (wsNotUse,     //  
                    wsDam,        //    
                    wsLimit);     //    
// -------------------------------------------------------------------------
// 02.01.2020
//      
// ( !)
type TAppScope = record
     SType   : char;       //  
                           // L- R- S-
     // --------------------
     Title   : string;     //  
     Xb, YB  : integer;    //     
     MinLX   : Integer;    //    L- 
     Meas    : string;     //   
     // ====================
     //  
     //    Max > P2R > P1Y > 0
     //   P2R = P1Y = 0,     
     //   
     Max     : extended;   //    
     P2R     : extended;   //    
     P1Y     : extended;   //    
     // --------------------
     //    Min < N1Y < N2R < 0
     //   N1Y = N2R = 0,     
     //   
     N1Y     : extended;   //    
     N2R     : extended;   //    
     Min     : extended;   //    
     // ====================
     //  
     // LB < LE   
     //   LB = LE = 0,     
     LB      : extended;   //   
     LE      : extended;   //   
     // --------------------
     WS      : TWallStyle; //   
     // ====================
     Compact : boolean;    //    ( L-)
     Transp  : boolean;    // 
     // --------------------
     NumLPF  : byte;       //     
     Grm1P   : extended;   //     (msec)
                           //    (-1  0)
     // --------------------
     Value   : extended;   //  
     // --------------------
end;

// =========================================================================
//       
// =========================================================================
//     
type TArrScopeOBJ = array of TObject;
//       
type TPtAllConst  = ^TAppConst;
//   
type TApp = record
  PtAllConst  : TPtAllConst;
  MaxIndx     : integer;
  PtArrDESC   : pointer;
  ArrSOBJ     : TArrScopeOBJ;
end;
//     
type TPtApp = ^TApp;

// =========================================================================
//       
// =========================================================================
//  -  
type TAllPtScopeArr = array of TPtApp;

// =========================================================================
//       
// =========================================================================
//    
type TSampleArr = array of extended;
//   
type THeadSensors = record
    //  
    Title   : string;            //  
    Min     : extended;          //    
    Max     : extended;          //    
    Value   : extended;          //    
    RqNoise : boolean;           //   
    Noise   : extended;          //  
    //   
    SampInd : integer;           //    
    SampArr : TSampleArr;        //   
end;

//     
//  -    
type TAppSensorArr = array of THeadSensors;

// =========================================================================
//       
// =========================================================================
//  -  
type TAllSensorArr = array of record
  AppName      : string;
  AppSensorArr : TAppSensorArr;
end;

// ==========================================================================
//   
// ==========================================================================
// --------------------------------------------------------------------------
//      
//       BufferMaxIndx + 1
const BufferMaxIndx  = 23;

type  TMaxArrDESC = array[0..BufferMaxIndx] of TAppScope;

type  TBufferItem = packed record
         Indx  : integer;
         Value : extended;
end;

type  TDataBuffer = packed record
         BufArr : array[0..BufferMaxIndx] of TBufferItem;
end;


// =========================================================================
//       
// =========================================================================
//      ( 1 msec)
//    unit MMSystem.pas
type TTimeStampsMM = record
  MMErr  : word;             //      
  BTime  : LongInt;          //    msec
  ETime  : LongInt;          //    msec
end;



// ==========================================================================
implementation
// ==========================================================================

// ==========================================================================
// 
// ==========================================================================
end.
